<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Tests;

use Pipedrive\APIException;
use Pipedrive\Exceptions;
use Pipedrive\APIHelper;
use Pipedrive\Models;

class MailThreadsControllerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \Pipedrive\Controllers\MailThreadsController Controller instance
     */
    protected static $controller;

    /**
     * @var HttpCallBackCatcher Callback
     */
    protected $httpResponse;

    /**
     * Setup test class
     */
    public static function setUpBeforeClass()
    {
        $client = new \Pipedrive\Client();
        self::$controller = $client->getMailThreads();
    }

    /**
     * Setup test
     */
    protected function setUp()
    {
        $this->httpResponse = new HttpCallBackCatcher();
    }

    /**
     * Returns mail threads in specified folder ordered by most recent message within.
     */
    public function testTestGetMailThreads()
    {
        // Parameters for the API call
        $input = array();
        $input['folder'] = TestHelper::getJsonMapper()->mapClass(json_decode(
            'inbox'),
            'Pipedrive\\Models\\string'
        );
        $input['start'] = 0;
        $input['limit'] = null;

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            $result = self::$controller->getMailThreads($input);
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );

        // Test headers
        $headers = [];
        $headers['Content-Type'] = 'application/json' ;

        $this->assertTrue(
            TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match"
        );

        // Test whether the captured response is as we expected
        $this->assertNotNull($result, "Result does not exist");

        $this->assertTrue(
            TestHelper::isJsonObjectProperSubsetOf(
                "{\"success\":true,\"data\":[{\"id\":1,\"parties\":{\"to\":[{\"id\":2,\"name\":\"\",\"latest_sent\":f" .
                "alse,\"email_address\":\"example@test.com\",\"message_time\":1574677850000,\"linked_person_id\":3,\"" .
                "linked_person_name\":\"Tester\",\"linked_organization_id\":null,\"mail_message_party_id\":5318}],\"f" .
                "rom\":[{\"id\":3,\"name\":\"\",\"latest_sent\":false,\"email_address\":\"example@test.com\",\"messag" .
                "e_time\":1574677850000,\"linked_person_id\":2,\"linked_person_name\":\"Tester\",\"linked_organizatio" .
                "n_id\":null,\"mail_message_party_id\":5318}]},\"drafts_parties\":[],\"folders\":[\"inbox\"],\"accoun" .
                "t_id\":\"123412jhfsaa221\",\"user_id\":232,\"version\":9,\"subject\":\"Example\",\"snippet\":\"Examp" .
                "le Snippet\",\"snippet_draft\":null,\"snippet_sent\":\"\",\"has_attachments_flag\":1,\"has_inline_at" .
                "tachments_flag\":1,\"has_real_attachments_flag\":0,\"has_draft_flag\":0,\"has_sent_flag\":0,\"archiv" .
                "ed_flag\":0,\"deleted_flag\":0,\"shared_flag\":1,\"synced_flag\":1,\"external_deleted_flag\":0,\"sma" .
                "rt_bcc_flag\":0,\"first_message_to_me_flag\":1,\"mail_link_tracking_enabled_flag\":0,\"last_message_" .
                "timestamp\":\"2019-11-20T20:20:46.000Z\",\"first_message_timestamp\":\"2019-11-20T17:40:46.000Z\",\"" .
                "last_message_sent_timestamp\":null,\"last_message_received_timestamp\":\"2019-11-20T20:20:46.000Z\"," .
                "\"add_time\":\"2019-11-20T17:40:59.000Z\",\"update_time\":\"2019-11-20T20:21:22.000Z\",\"deal_id\":n" .
                "ull,\"deal_status\":null,\"write_flag\":true,\"all_messages_sent_flag\":0}]}",
                $this->httpResponse->getResponse()->getRawBody(),
                false,
                true,
                false
            ),
            "Response body does not match in keys"
        );
    }
}
