<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;

/**
 *The total values of Deals for the given period
 */
class Totals implements JsonSerializable
{
    /**
     * The number of Deals for the given period
     * @var integer|null $count public property
     */
    public $count;

    /**
     * The total values of Deals grouped by Deal currency
     * @var object|null $values public property
     */
    public $values;

    /**
     * The total weighted values of Deals for the given period grouped by Deal currency. The weighted value
     * of a Deal is calculated as probability times Deal value.
     * @maps weighted_values
     * @var object|null $weightedValues public property
     */
    public $weightedValues;

    /**
     * The number of open Deals for the given period
     * @maps open_count
     * @var integer|null $openCount public property
     */
    public $openCount;

    /**
     * The total values of open Deals for the given period grouped by Deal currency
     * @maps open_values
     * @var object|null $openValues public property
     */
    public $openValues;

    /**
     * The total weighted values of open Deals for the given period grouped by Deal currency. The weighted
     * value of a Deal is calculated as probability times Deal value.
     * @maps weighted_open_values
     * @var object|null $weightedOpenValues public property
     */
    public $weightedOpenValues;

    /**
     * The number of won Deals for the given period
     * @maps won_count
     * @var integer|null $wonCount public property
     */
    public $wonCount;

    /**
     * The total values of won Deals for the given period grouped by Deal currency
     * @maps won_values
     * @var object|null $wonValues public property
     */
    public $wonValues;

    /**
     * Constructor to set initial or default values of member properties
     * @param integer $count              Initialization value for $this->count
     * @param object  $values             Initialization value for $this->values
     * @param object  $weightedValues     Initialization value for $this->weightedValues
     * @param integer $openCount          Initialization value for $this->openCount
     * @param object  $openValues         Initialization value for $this->openValues
     * @param object  $weightedOpenValues Initialization value for $this->weightedOpenValues
     * @param integer $wonCount           Initialization value for $this->wonCount
     * @param object  $wonValues          Initialization value for $this->wonValues
     */
    public function __construct()
    {
        if (8 == func_num_args()) {
            $this->count              = func_get_arg(0);
            $this->values             = func_get_arg(1);
            $this->weightedValues     = func_get_arg(2);
            $this->openCount          = func_get_arg(3);
            $this->openValues         = func_get_arg(4);
            $this->weightedOpenValues = func_get_arg(5);
            $this->wonCount           = func_get_arg(6);
            $this->wonValues          = func_get_arg(7);
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['count']                = $this->count;
        $json['values']               = $this->values;
        $json['weighted_values']      = $this->weightedValues;
        $json['open_count']           = $this->openCount;
        $json['open_values']          = $this->openValues;
        $json['weighted_open_values'] = $this->weightedOpenValues;
        $json['won_count']            = $this->wonCount;
        $json['won_values']           = $this->wonValues;

        return $json;
    }
}
