<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;

/**
 * @todo Write general description for this model
 */
class BasicDealProduct implements JsonSerializable
{
    /**
     * Price at which this product will be added to the deal
     * @maps item_price
     * @var double|null $itemPrice public property
     */
    public $itemPrice;

    /**
     * Quantity – e.g. how many items of this product will be added to the deal
     * @var integer|null $quantity public property
     */
    public $quantity;

    /**
     * Discount %. If omitted, will be set to 0
     * @maps discount_percentage
     * @var double|null $discountPercentage public property
     */
    public $discountPercentage;

    /**
     * Duration of the product (when product durations are not enabled for the company or if omitted,
     * defaults to 1)
     * @var double|null $duration public property
     */
    public $duration;

    /**
     * ID of the product variation to use. When omitted, no variation will be used.
     * @maps product_variation_id
     * @var integer|null $productVariationId public property
     */
    public $productVariationId;

    /**
     * Any textual comment associated with this product-deal attachment. Visible and editable in the
     * application UI.
     * @var string|null $comments public property
     */
    public $comments;

    /**
     * Whether the product is enabled on the deal or not. This makes it possible to add products to a deal
     * with specific price and discount criteria - but keep them disabled, which refrains them from being
     * included in deal price calculation. When omitted, the product will be marked as enabled by default.
     * @maps enabled_flag
     * @var int|null $enabledFlag public property
     */
    public $enabledFlag;

    /**
     * Constructor to set initial or default values of member properties
     * @param double  $itemPrice          Initialization value for $this->itemPrice
     * @param integer $quantity           Initialization value for $this->quantity
     * @param double  $discountPercentage Initialization value for $this->discountPercentage
     * @param double  $duration           Initialization value for $this->duration
     * @param integer $productVariationId Initialization value for $this->productVariationId
     * @param string  $comments           Initialization value for $this->comments
     * @param int     $enabledFlag        Initialization value for $this->enabledFlag
     */
    public function __construct()
    {
        switch (func_num_args()) {
            case 7:
                $this->itemPrice          = func_get_arg(0);
                $this->quantity           = func_get_arg(1);
                $this->discountPercentage = func_get_arg(2);
                $this->duration           = func_get_arg(3);
                $this->productVariationId = func_get_arg(4);
                $this->comments           = func_get_arg(5);
                $this->enabledFlag        = func_get_arg(6);
                break;

            default:
                $this->discountPercentage = 0;
                $this->duration = 1;
                break;
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['item_price']           = $this->itemPrice;
        $json['quantity']             = $this->quantity;
        $json['discount_percentage']  = $this->discountPercentage;
        $json['duration']             = $this->duration;
        $json['product_variation_id'] = $this->productVariationId;
        $json['comments']             = $this->comments;
        $json['enabled_flag']         = $this->enabledFlag;

        return $json;
    }
}
