<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;

/**
 * @todo Write general description for this model
 */
class BaseNote implements JsonSerializable
{
    /**
     * The ID of the Note
     * @var integer|null $id public property
     */
    public $id;

    /**
     * If Note is active or deleted
     * @maps active_flag
     * @var bool|null $activeFlag public property
     */
    public $activeFlag;

    /**
     * The creation date and time of the Note
     * @maps add_time
     * @var string|null $addTime public property
     */
    public $addTime;

    /**
     * Content of the Note in HTML format. Subject to sanitization on the back-end.
     * @var string|null $content public property
     */
    public $content;

    /**
     * The Deal this Note is attached to
     * @var \Pipedrive\Models\BaseNoteDealTitle|null $deal public property
     */
    public $deal;

    /**
     * The ID of the Lead the Note is attached to
     * @maps lead_id
     * @var string|null $leadId public property
     */
    public $leadId;

    /**
     * The ID of the Deal the Note is attached to
     * @maps deal_id
     * @var integer|null $dealId public property
     */
    public $dealId;

    /**
     * The ID of the User who updated the Note last
     * @maps last_update_user_id
     * @var integer|null $lastUpdateUserId public property
     */
    public $lastUpdateUserId;

    /**
     * The ID of the Organization this Note is attached to
     * @maps org_id
     * @var integer|null $orgId public property
     */
    public $orgId;

    /**
     * The Organization this Note is attached to
     * @var \Pipedrive\Models\Organization|null $organization public property
     */
    public $organization;

    /**
     * The Person this Note is attached to
     * @var \Pipedrive\Models\Person|null $person public property
     */
    public $person;

    /**
     * The ID of the Person this Note is attached to
     * @maps person_id
     * @var integer|null $personId public property
     */
    public $personId;

    /**
     * If true, then the results are filtered by Note to Lead pinning state.
     * @maps pinned_to_lead_flag
     * @var bool|null $pinnedToLeadFlag public property
     */
    public $pinnedToLeadFlag;

    /**
     * If true, then the results are filtered by Note to Deal pinning state.
     * @maps pinned_to_deal_flag
     * @var bool|null $pinnedToDealFlag public property
     */
    public $pinnedToDealFlag;

    /**
     * If true, then the results are filtered by Note to Organization pinning state.
     * @maps pinned_to_organization_flag
     * @var bool|null $pinnedToOrganizationFlag public property
     */
    public $pinnedToOrganizationFlag;

    /**
     * If true, then the results are filtered by Note to Person pinning state.
     * @maps pinned_to_person_flag
     * @var bool|null $pinnedToPersonFlag public property
     */
    public $pinnedToPersonFlag;

    /**
     * The last updated date and time of the Note
     * @maps update_time
     * @var string|null $updateTime public property
     */
    public $updateTime;

    /**
     * The User who created the Note
     * @var \Pipedrive\Models\NoteCreatorUser|null $user public property
     */
    public $user;

    /**
     * The ID of the Note creator
     * @maps user_id
     * @var integer|null $userId public property
     */
    public $userId;

    /**
     * Constructor to set initial or default values of member properties
     * @param integer           $id                       Initialization value for $this->id
     * @param bool              $activeFlag               Initialization value for $this->activeFlag
     * @param string            $addTime                  Initialization value for $this->addTime
     * @param string            $content                  Initialization value for $this->content
     * @param BaseNoteDealTitle $deal                     Initialization value for $this->deal
     * @param string            $leadId                   Initialization value for $this->leadId
     * @param integer           $dealId                   Initialization value for $this->dealId
     * @param integer           $lastUpdateUserId         Initialization value for $this->lastUpdateUserId
     * @param integer           $orgId                    Initialization value for $this->orgId
     * @param Organization      $organization             Initialization value for $this->organization
     * @param Person            $person                   Initialization value for $this->person
     * @param integer           $personId                 Initialization value for $this->personId
     * @param bool              $pinnedToLeadFlag         Initialization value for $this->pinnedToLeadFlag
     * @param bool              $pinnedToDealFlag         Initialization value for $this->pinnedToDealFlag
     * @param bool              $pinnedToOrganizationFlag Initialization value for $this->pinnedToOrganizationFlag
     * @param bool              $pinnedToPersonFlag       Initialization value for $this->pinnedToPersonFlag
     * @param string            $updateTime               Initialization value for $this->updateTime
     * @param NoteCreatorUser   $user                     Initialization value for $this->user
     * @param integer           $userId                   Initialization value for $this->userId
     */
    public function __construct()
    {
        if (19 == func_num_args()) {
            $this->id                       = func_get_arg(0);
            $this->activeFlag               = func_get_arg(1);
            $this->addTime                  = func_get_arg(2);
            $this->content                  = func_get_arg(3);
            $this->deal                     = func_get_arg(4);
            $this->leadId                   = func_get_arg(5);
            $this->dealId                   = func_get_arg(6);
            $this->lastUpdateUserId         = func_get_arg(7);
            $this->orgId                    = func_get_arg(8);
            $this->organization             = func_get_arg(9);
            $this->person                   = func_get_arg(10);
            $this->personId                 = func_get_arg(11);
            $this->pinnedToLeadFlag         = func_get_arg(12);
            $this->pinnedToDealFlag         = func_get_arg(13);
            $this->pinnedToOrganizationFlag = func_get_arg(14);
            $this->pinnedToPersonFlag       = func_get_arg(15);
            $this->updateTime               = func_get_arg(16);
            $this->user                     = func_get_arg(17);
            $this->userId                   = func_get_arg(18);
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['id']                          = $this->id;
        $json['active_flag']                 = $this->activeFlag;
        $json['add_time']                    = $this->addTime;
        $json['content']                     = $this->content;
        $json['deal']                        = $this->deal;
        $json['lead_id']                     = $this->leadId;
        $json['deal_id']                     = $this->dealId;
        $json['last_update_user_id']         = $this->lastUpdateUserId;
        $json['org_id']                      = $this->orgId;
        $json['organization']                = $this->organization;
        $json['person']                      = $this->person;
        $json['person_id']                   = $this->personId;
        $json['pinned_to_lead_flag']         = $this->pinnedToLeadFlag;
        $json['pinned_to_deal_flag']         = $this->pinnedToDealFlag;
        $json['pinned_to_organization_flag'] = $this->pinnedToOrganizationFlag;
        $json['pinned_to_person_flag']       = $this->pinnedToPersonFlag;
        $json['update_time']                 = $this->updateTime;
        $json['user']                        = $this->user;
        $json['user_id']                     = $this->userId;

        return $json;
    }
}
