<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Controllers;

use Pipedrive\APIException;
use Pipedrive\APIHelper;
use Pipedrive\Configuration;
use Pipedrive\Models;
use Pipedrive\Exceptions;
use Pipedrive\Http\HttpRequest;
use Pipedrive\Http\HttpResponse;
use Pipedrive\Http\HttpMethod;
use Pipedrive\Http\HttpContext;
use Pipedrive\OAuthManager;
use Pipedrive\Servers;
use Pipedrive\Utils\CamelCaseHelper;
use Unirest\Request;

/**
 * @todo Add a general description for this controller.
 */
class WebhooksController extends BaseController
{
    /**
     * @var WebhooksController The reference to *Singleton* instance of this class
     */
    private static $instance;

    /**
     * Returns the *Singleton* instance of this class.
     * @return WebhooksController The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * Returns data about all webhooks of a company.
     *
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getAllWebhooks()
    {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/webhooks';

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //Error handling using HTTP status codes
        if ($response->code == 401) {
            throw new Exceptions\UnauthorizedException('Unauthorized response', $_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\WebhooksResponse'));
    }

    /**
     * Creates a new webhook and returns its details. Note that specifying an event which triggers the
     * webhook combines 2 parameters - 'event_action' and 'event_object'. E.g., use '\*.\*' for getting
     * notifications about all events, 'added.deal' for any newly added deals, 'deleted.persons' for any
     * deleted persons, etc. See <a href="https://pipedrive.readme.io/docs/guide-for-webhooks?
     * utm_source=api_reference">https://pipedrive.readme.io/docs/guide-for-webhooks</a> for more details.
     *
     * @param  array  $options    Array with all options for search
     * @param string  $options['subscriptionUrl']    A full, valid, publicly accessible URL. Determines where to send
     *                                               the notifications. Please note that you cannot use Pipedrive API
     *                                               endpoints as the subscription_url.
     * @param string  $options['eventAction']        Type of action to receive notifications about. Wildcard will match
     *                                               all supported actions.
     * @param string  $options['eventObject']        Type of object to receive notifications about. Wildcard will match
     *                                               all supported objects.
     * @param integer $options['userId']             (optional) The ID of the user this webhook will be authorized with.
     *                                               If not set, current authorized user will be used. Note that this
     *                                               does not filter only certain user's events — rather, this
     *                                               specifies the user's permissions under which each event is checked.
     *                                               Events about objects the selected user is not entitled to access
     *                                               are not sent. If you want to receive notifications for all events,
     *                                               a top-level admin user should be used.
     * @param string  $options['httpAuthUser']       (optional) HTTP basic auth username of the subscription URL
     *                                               endpoint (if required).
     * @param string  $options['httpAuthPassword']   (optional) HTTP basic auth password of the subscription URL
     *                                               endpoint (if required).
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function createANewWebhook(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/webhooks';

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'       => BaseController::USER_AGENT,
            'Accept'           => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'subscription_url'   => $this->val($options, 'subscriptionUrl'),
            'event_action'     => APIHelper::prepareFormFields($this->val($options, 'eventAction')),
            'event_object'     => APIHelper::prepareFormFields($this->val($options, 'eventObject')),
            'user_id'            => $this->val($options, 'userId'),
            'http_auth_user'     => $this->val($options, 'httpAuthUser'),
            'http_auth_password' => $this->val($options, 'httpAuthPassword')
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //Error handling using HTTP status codes
        if ($response->code == 400) {
            throw new Exceptions\SchemaException('The bad response on webhook creation', $_httpContext);
        }

        if ($response->code == 401) {
            throw new Exceptions\UnauthorizedException('Unauthorized response', $_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\WebhooksResponse1'));
    }

    /**
     * Deletes the specified webhook.
     *
     * @param integer $id The ID of the webhook to delete
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteExistingWebhook(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/webhooks/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //Error handling using HTTP status codes
        if ($response->code == 401) {
            throw new Exceptions\UnauthorizedException('Unauthorized response', $_httpContext);
        }

        if ($response->code == 403) {
            throw new Exceptions\Webhooks403ErrorException('The webhook deletion forbidden response', $_httpContext);
        }

        if ($response->code == 404) {
            throw new Exceptions\SchemaException('The webhook deletion not found response', $_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\Schema1'));
    }


    /**
    * Array access utility method
     * @param  array          $arr         Array of values to read from
     * @param  string         $key         Key to get the value from the array
     * @param  mixed|null     $default     Default value to use if the key was not found
     * @return mixed
     */
    private function val($arr, $key, $default = null)
    {
        if (isset($arr[$key])) {
            return is_bool($arr[$key]) ? var_export($arr[$key], true) : $arr[$key];
        }
        return $default;
    }
}
