<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Controllers;

use Pipedrive\APIException;
use Pipedrive\APIHelper;
use Pipedrive\Configuration;
use Pipedrive\Models;
use Pipedrive\Exceptions;
use Pipedrive\Utils\DateTimeHelper;
use Pipedrive\Http\HttpRequest;
use Pipedrive\Http\HttpResponse;
use Pipedrive\Http\HttpMethod;
use Pipedrive\Http\HttpContext;
use Pipedrive\OAuthManager;
use Pipedrive\Servers;
use Pipedrive\Utils\CamelCaseHelper;
use Unirest\Request;

/**
 * @todo Add a general description for this controller.
 */
class DealsController extends BaseController
{
    /**
     * @var DealsController The reference to *Singleton* instance of this class
     */
    private static $instance;

    /**
     * Returns the *Singleton* instance of this class.
     * @return DealsController The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * Marks multiple deals as deleted.
     *
     * @param string $ids Comma-separated IDs that will be deleted
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteMultipleDealsInBulk(
        $ids
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'ids' => $ids,
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\DeleteMultipleDeals'));
    }

    /**
     * Returns all deals. For more information on how to get all deals, see <a href="https://pipedrive.
     * readme.io/docs/getting-all-deals" target="_blank" rel="noopener noreferrer">this tutorial</a>.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['userId']       (optional) If supplied, only deals matching the given user will be
     *                                         returned.
     * @param integer $options['filterId']     (optional) ID of the filter to use
     * @param integer $options['stageId']      (optional) If supplied, only deals within the given stage will be
     *                                         returned.
     * @param string  $options['status']       (optional) Only fetch deals with specific status. If omitted, all not
     *                                         deleted deals are fetched.
     * @param integer $options['start']        (optional) Pagination start
     * @param integer $options['limit']        (optional) Items shown per page
     * @param string  $options['sort']         (optional) Field names and sorting mode separated by a comma
     *                                         (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are
     *                                         supported (no nested keys).
     * @param int     $options['ownedByYou']   (optional) When supplied, only deals owned by you are returned. However
     *                                         filter_id takes precedence over owned_by_you when both are supplied.
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getAllDeals(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'user_id'      => $this->val($options, 'userId'),
            'filter_id'    => $this->val($options, 'filterId'),
            'stage_id'     => $this->val($options, 'stageId'),
            'status'       => $this->val($options, 'status', Models\Status2Enum::ALL_NOT_DELETED),
            'start'        => $this->val($options, 'start', 0),
            'limit'        => $this->val($options, 'limit'),
            'sort'         => $this->val($options, 'sort'),
            'owned_by_you' => $this->val($options, 'ownedByYou'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetDeals'));
    }

    /**
     * Adds a new deal. Note that you can supply additional custom fields along with the request that are
     * not described here. These custom fields are different for each Pipedrive account and can be
     * recognized by long hashes as keys. To determine which custom fields exists, fetch the dealFields and
     * look for 'key' values. For more information on how to add a deal, see <a href="https://pipedrive.
     * readme.io/docs/creating-a-deal" target="_blank" rel="noopener noreferrer">this tutorial</a>.
     *
     * @param object $body (optional) TODO: type description here
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function addADeal(
        $body = null
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals';

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'content-type'  => 'application/json; charset=utf-8',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //json encode body
        $_bodyJson = Request\Body::Json($body);

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, $_bodyJson);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetAddedDeal'));
    }

    /**
     * Returns summary of all the deals.
     *
     * @param  array  $options    Array with all options for search
     * @param string  $options['status']    (optional) Only fetch deals with specific status. open = Open, won = Won,
     *                                      lost = Lost
     * @param integer $options['filterId']  (optional) user_id will not be considered. Only deals matching the given
     *                                      filter will be returned.
     * @param integer $options['userId']    (optional) Only deals matching the given user will be returned. user_id
     *                                      will not be considered if you use filter_id.
     * @param integer $options['stageId']   (optional) Only deals within the given stage will be returned.
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getDealsSummary(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/summary';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'status'    => $this->val($options, 'status'),
            'filter_id' => $this->val($options, 'filterId'),
            'user_id'   => $this->val($options, 'userId'),
            'stage_id'  => $this->val($options, 'stageId'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetDealsSummary'));
    }

    /**
     * Returns open and won deals, grouped by defined interval of time set in a date-type dealField
     * (field_key) — e.g. when month is the chosen interval, and 3 months are asked starting from  January
     * 1st, 2012, deals are returned grouped into 3 groups — January, February and March — based on the
     * value of the given field_key.
     *
     * @param  array  $options    Array with all options for search
     * @param DateTime $options['startDate']               Date where first interval starts. Format: YYYY-MM-DD
     * @param string   $options['interval']                Type of interval.<dl class="fields-
     *                                                     list"><dt>day</dt><dd>Day</dd><dt>week</dt><dd>A full week
     *                                                     (7 days) starting from start_date</dd><dt>month</dt><dd>A
     *                                                     full month (depending on the number of days in given month)
     *                                                     starting from start_date</dd><dt>quarter</dt><dd>A full
     *                                                     quarter (3 months) starting from start_date</dd></dl>
     * @param integer  $options['amount']                  Number of given intervals, starting from start_date, to
     *                                                     fetch. E.g. 3 (months).
     * @param string   $options['fieldKey']                The name of the date field by which to get deals by.
     * @param integer  $options['userId']                  (optional) If supplied, only deals matching the given user
     *                                                     will be returned.
     * @param integer  $options['pipelineId']              (optional) If supplied, only deals matching the given
     *                                                     pipeline will be returned.
     * @param integer  $options['filterId']                (optional) If supplied, only deals matching the given filter
     *                                                     will be returned.
     * @param int      $options['excludeDeals']            (optional) Whether to exclude deals list (1) or not (0).
     *                                                     Note that when deals are excluded, the timeline summary
     *                                                     (counts and values) is still returned.
     * @param string   $options['totalsConvertCurrency']   (optional) 3-letter currency code of any of the supported
     *                                                     currencies. When supplied, totals_converted is returned per
     *                                                     each interval which contains the currency-converted total
     *                                                     amounts in the given currency. You may also set this
     *                                                     parameter to 'default_currency' in which case users default
     *                                                     currency is used.
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getDealsTimeline(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/timeline';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start_date'              => DateTimeHelper::toSimpleDate($this->val($options, 'startDate')),
            'interval'                => $this->val($options, 'interval'),
            'amount'                  => $this->val($options, 'amount'),
            'field_key'               => $this->val($options, 'fieldKey'),
            'user_id'                 => $this->val($options, 'userId'),
            'pipeline_id'             => $this->val($options, 'pipelineId'),
            'filter_id'               => $this->val($options, 'filterId'),
            'exclude_deals'           => $this->val($options, 'excludeDeals'),
            'totals_convert_currency' => $this->val($options, 'totalsConvertCurrency'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'            => BaseController::USER_AGENT,
            'Accept'                => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetDealsTimeline'));
    }

    /**
     * Marks a deal as deleted.
     *
     * @param integer $id ID of the deal
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteADeal(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\DeleteDeal'));
    }

    /**
     * Returns details of a specific deal. Note that this also returns some additional fields which are not
     * present when asking for all deals – such as deal age and stay in pipeline stages. Also note that
     * custom fields appear as long hashes in the resulting data. These hashes can be mapped against the
     * 'key' value of dealFields. For more information on how to get all details of a deal, see <a
     * href="https://pipedrive.readme.io/docs/getting-details-of-a-deal" target="_blank" rel="noopener
     * noreferrer">this tutorial</a>.
     *
     * @param integer $id ID of the deal
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getDetailsOfADeal(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetDeal'));
    }

    /**
     * Updates the properties of a deal. For more information on how to update a deal, see <a href="https:
     * //pipedrive.readme.io/docs/updating-a-deal" target="_blank" rel="noopener noreferrer">this
     * tutorial</a>.
     *
     * Note that you can supply additional custom fields along with the request that are
     * not described here. These custom fields are different for each Pipedrive account and can be
     * recognized by long hashes as keys. To determine which custom fields exists, fetch the dealFields and
     * look for 'key' values.
     *
     * @param array   $options                Array with all options for search
     * @param integer $options['id']          ID of the deal
     * @param string  $options['title']       (optional) Deal title
     * @param string  $options['value']       (optional) Value of the deal. If omitted, value will be set to 0.
     * @param string  $options['currency']    (optional) Currency of the deal. Accepts a 3-character currency code. If
     *                                        omitted, currency will be set to the default currency of the authorized
     *                                        user.
     * @param integer $options['userId']      (optional) ID of the user who will be marked as the owner of this deal.
     *                                        If omitted, the authorized user ID will be used.
     * @param integer $options['personId']    (optional) ID of the person this deal will be associated with
     * @param integer $options['orgId']       (optional) ID of the organization this deal will be associated with
     * @param integer $options['stageId']     (optional) ID of the stage this deal will be placed in a pipeline (note
     *                                        that you can't supply the ID of the pipeline as this will be assigned
     *                                        automatically based on stage_id). If omitted, the deal will be placed in
     *                                        the first stage of the default pipeline.
     * @param string  $options['status']      (optional) open = Open, won = Won, lost = Lost, deleted = Deleted. If
     *                                        omitted, status will be set to open.
     * @param double  $options['probability'] (optional) Deal success probability percentage. Used/shown only when
     *                                        deal_probability for the pipeline of the deal is enabled.
     * @param string  $options['lostReason']  (optional) Optional message about why the deal was lost (to be used when
     *                                        status=lost)
     * @param int     $options['visibleTo']   (optional) Visibility of the deal. If omitted, visibility will be set to
     *                                        the default visibility setting of this item type for the authorized user.
     *                                        <dl class="fields-list"><dt>1</dt><dd>Owner &amp; followers
     *                                        (private)</dd><dt>3</dt><dd>Entire company (shared)</dd></dl>
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function updateADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array(
            'id' => $this->val($options, 'id'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'content-type'  => 'application/json; charset=utf-8',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::PUT, $_headers, $_queryUrl, $options);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::put($_queryUrl, $_headers, Request\Body::Json($options));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetAddedDeal'));
    }

    /**
     * Lists activities associated with a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']      ID of the deal
     * @param integer $options['start']   (optional) Pagination start
     * @param integer $options['limit']   (optional) Items shown per page
     * @param int     $options['done']    (optional) Whether the activity is done or not. 0 = Not done, 1 = Done. If
     *                                    omitted returns both Done and Not done activities.
     * @param string  $options['exclude'] (optional) A comma-separated string of activity IDs to exclude from result
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listActivitiesAssociatedWithADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/activities';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'      => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start'   => $this->val($options, 'start', 0),
            'limit'   => $this->val($options, 'limit'),
            'done'    => $this->val($options, 'done'),
            'exclude' => $this->val($options, 'exclude'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Duplicate a deal
     *
     * @param integer $id ID of the deal
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function createDuplicateDeal(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/duplicate';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetDuplicatedDeal'));
    }

    /**
     * Lists files associated with a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']                    ID of the deal
     * @param integer $options['start']                 (optional) Pagination start
     * @param integer $options['limit']                 (optional) Items shown per page
     * @param int     $options['includeDeletedFiles']   (optional) When enabled, the list of files will also include
     *                                                  deleted files. Please note that trying to download these files
     *                                                  will not work.
     * @param string  $options['sort']                  (optional) Field names and sorting mode separated by a comma
     *                                                  (field_name_1 ASC, field_name_2 DESC). Only first-level field
     *                                                  keys are supported (no nested keys). Supported fields: id,
     *                                                  user_id, deal_id, person_id, org_id, product_id, add_time,
     *                                                  update_time, file_name, file_type, file_size, comment.
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listFilesAttachedToADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/files';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                    => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start'                 => $this->val($options, 'start', 0),
            'limit'                 => $this->val($options, 'limit'),
            'include_deleted_files' => $this->val($options, 'includeDeletedFiles'),
            'sort'                  => $this->val($options, 'sort'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'          => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Lists updates about a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']    ID of the deal
     * @param integer $options['start'] (optional) Pagination start
     * @param integer $options['limit'] (optional) Items shown per page
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listUpdatesAboutADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/flow';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'    => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start' => $this->val($options, 'start', 0),
            'limit' => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Lists the followers of a deal.
     *
     * @param integer $id ID of the deal
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listFollowersOfADeal(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/followers';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Adds a follower to a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']      ID of the deal
     * @param integer $options['userId']  ID of the user
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function addAFollowerToADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/followers';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'      => $this->val($options, 'id'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'user_id' => $this->val($options, 'userId')
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\AddedDealFollower'));
    }

    /**
     * Deletes a follower from a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']          ID of the deal
     * @param integer $options['followerId']  ID of the follower
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteAFollowerFromADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/followers/{follower_id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'          => $this->val($options, 'id'),
            'follower_id' => $this->val($options, 'followerId'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\DeleteDealFollower'));
    }

    /**
     * Lists mail messages associated with a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']    ID of the deal
     * @param integer $options['start'] (optional) Pagination start
     * @param integer $options['limit'] (optional) Items shown per page
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listMailMessagesAssociatedWithADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/mailMessages';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'    => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start' => $this->val($options, 'start', 0),
            'limit' => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Merges a deal with another deal. For more information on how to merge two deals, see <a href="https:
     * //pipedrive.readme.io/docs/merging-two-deals" target="_blank" rel="noopener noreferrer">this
     * tutorial</a>.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']            ID of the deal
     * @param integer $options['mergeWithId']   ID of the deal that the deal will be merged with
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function updateMergeTwoDeals(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/merge';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'            => $this->val($options, 'id'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'merge_with_id' => $this->val($options, 'mergeWithId')
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::PUT, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::put($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetMergedDeal'));
    }

    /**
     * Lists participants associated with a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']    ID of the deal
     * @param integer $options['start'] (optional) Pagination start
     * @param integer $options['limit'] (optional) Items shown per page
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listParticipantsOfADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/participants';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'    => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start' => $this->val($options, 'start', 0),
            'limit' => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Adds a participant to a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']        ID of the deal
     * @param integer $options['personId']  ID of the person
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function addAParticipantToADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/participants';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'        => $this->val($options, 'id'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'person_id' => $this->val($options, 'personId')
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Deletes a participant from a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']                  ID of the deal
     * @param integer $options['dealParticipantId']   ID of the deal participant
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteAParticipantFromADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/participants/{deal_participant_id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                  => $this->val($options, 'id'),
            'deal_participant_id' => $this->val($options, 'dealParticipantId'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'        => BaseController::USER_AGENT,
            'Accept'            => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\DeleteDealParticipant'));
    }

    /**
     * List users permitted to access a deal
     *
     * @param integer $id ID of the deal
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listPermittedUsers(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/permittedUsers';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Lists all persons associated with a deal, regardless of whether the person is the primary contact of
     * the deal, or added as a participant.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']    ID of the deal
     * @param integer $options['start'] (optional) Pagination start
     * @param integer $options['limit'] (optional) Items shown per page
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listAllPersonsAssociatedWithADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/persons';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'    => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start' => $this->val($options, 'start', 0),
            'limit' => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Lists products attached to a deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']                   ID of the deal
     * @param integer $options['start']                (optional) Pagination start
     * @param integer $options['limit']                (optional) Items shown per page
     * @param int     $options['includeProductData']   (optional) Whether to fetch product data along with each
     *                                                 attached product (1) or not (0, default).
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function listProductsAttachedToADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/products';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                   => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'start'                => $this->val($options, 'start', 0),
            'limit'                => $this->val($options, 'limit'),
            'include_product_data' => $this->val($options, 'includeProductData'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'         => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Adds a product to the deal.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']   ID of the deal
     * @param object  $options['body'] (optional) TODO: type description here
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function addAProductToTheDealEventuallyCreatingANewItemCalledADealProduct(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/products';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'   => $this->val($options, 'id'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Accept'        => 'application/json',
            'content-type'  => 'application/json; charset=utf-8',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //json encode body
        $_bodyJson = Request\Body::Json($this->val($options, 'body'));

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, $_bodyJson);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetAddProductAttachementDetails'));
    }

    /**
     * Updates product attachment details.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']                    ID of the deal
     * @param integer $options['productAttachmentId']   ID of the deal-product (the ID of the product attached to the
     *                                                  deal)
     * @param double  $options['itemPrice']             (optional) Price at which this product will be added to the
     *                                                  deal
     * @param integer $options['quantity']              (optional) Quantity – e.g. how many items of this product will
     *                                                  be added to the deal
     * @param double  $options['discountPercentage']    (optional) Discount %. If omitted, will be set to 0
     * @param double  $options['duration']              (optional) Duration of the product (when product durations are
     *                                                  not enabled for the company or if omitted, defaults to 1)
     * @param integer $options['productVariationId']    (optional) ID of the product variation to use. When omitted, no
     *                                                  variation will be used.
     * @param string  $options['comments']              (optional) Any textual comment associated with this product-
     *                                                  deal attachment. Visible and editable in the application UI.
     * @param int     $options['enabledFlag']           (optional) Whether the product is enabled on the deal or not.
     *                                                  This makes it possible to add products to a deal with specific
     *                                                  price and discount criteria - but keep them disabled, which
     *                                                  refrains them from being included in deal price calculation.
     *                                                  When omitted, the product will be marked as enabled by default.
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function updateProductAttachmentDetailsOfTheDealProductAProductAlreadyAttachedToADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/products/{product_attachment_id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                    => $this->val($options, 'id'),
            'product_attachment_id' => $this->val($options, 'productAttachmentId'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'          => BaseController::USER_AGENT,
            'Accept'              => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'item_price'            => $this->val($options, 'itemPrice'),
            'quantity'              => $this->val($options, 'quantity'),
            'discount_percentage'   => $this->val($options, 'discountPercentage'),
            'duration'              => $this->val($options, 'duration'),
            'product_variation_id'  => $this->val($options, 'productVariationId'),
            'comments'              => $this->val($options, 'comments'),
            'enabled_flag'        => APIHelper::prepareFormFields($this->val($options, 'enabledFlag'))
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::PUT, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::put($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\GetProductAttachementDetails'));
    }

    /**
     * Deletes a product attachment from a deal, using the product_attachment_id.
     *
     * @param  array  $options    Array with all options for search
     * @param integer $options['id']                    ID of the deal
     * @param integer $options['productAttachmentId']   Product attachment ID. This is returned as
     *                                                  product_attachment_id after attaching a product to a deal or as
     *                                                  id when listing the products attached to a deal.
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteAnAttachedProductFromADeal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/{id}/products/{product_attachment_id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                    => $this->val($options, 'id'),
            'product_attachment_id' => $this->val($options, 'productAttachmentId'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'          => BaseController::USER_AGENT,
            'Accept'              => 'application/json',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        $mapper = $this->getJsonMapper();

        return CamelCaseHelper::keysToCamelCase($mapper->mapClass($response->body, 'Pipedrive\\Models\\DeleteDealProduct'));
    }

    /**
     * Searches all Deals by title, notes and/or custom fields. This endpoint is a wrapper of /v1/itemSearch with a narrower OAuth scope. Found Deals can be filtered by Person ID and Organization ID.
     *
     * @param  array  $options    Array with all options for search
     * @param string  $options['term']        The search term to look for. Minimum 2 characters (or 1 if using exact_match).
     * @param string  $options['fields']      (optional) A comma-separated string array. The fields to perform the search from. Defaults to all of them.
     * @param bool    $options['exactMatch']  (optional) When enabled, only full exact matches against the given term are returned. It is not case sensitive.
     * @param integer $options['personId']    (optional) Will filter Deals by the provided Person ID. The upper limit of found Deals associated with the Person is 2000.
     * @param integer $options['organizationId']    (optional) Will filter Deals by the provided Organization ID. The upper limit of found Deals associated with the Organization is 2000.
     * @param string  $options['status']      (optional) Will filter Deals by the provided specific status. open = Open, won = Won, lost = Lost. The upper limit of found Deals associated with the status is 2000.
     * @param string  $options['includeFields']      (optional) Supports including optional fields in the results which are not provided by default.
     * @param integer $options['start']       (optional) Pagination start. Note that the pagination is based on main results and does not include related items when using search_for_related_items parameter.
     * @param integer $options['limit']       (optional) Items shown per page
     *
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function searchDeals(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/deals/search';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'term'        => $this->val($options, 'term'),
            'fields'  => $this->val($options, 'fields'),
            'exact_match' => $this->val($options, 'exactMatch'),
            'person_id'   => $this->val($options, 'personId'),
            'organization_id'   => $this->val($options, 'organizationId'),
            'status'   => $this->val($options, 'status'),
            'include_fields'   => $this->val($options, 'includeFields'),
            'start'       => $this->val($options, 'start', 0),
            'limit'       => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }


    /**
    * Array access utility method
     * @param  array          $arr         Array of values to read from
     * @param  string         $key         Key to get the value from the array
     * @param  mixed|null     $default     Default value to use if the key was not found
     * @return mixed
     */
    private function val($arr, $key, $default = null)
    {
        if (isset($arr[$key])) {
            return is_bool($arr[$key]) ? var_export($arr[$key], true) : $arr[$key];
        }
        return $default;
    }
}
